package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.VfichaAperturaDao;
import com.ejie.ab04b.model.VfichaApertura;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VfichaAperturaServiceImpl generated by UDA, 16-jun-2017 10:17:16.
 * 
 * @author UDA
 */

@Service(value = "vfichaAperturaService")
public class VfichaAperturaServiceImpl implements VfichaAperturaService {

	@Autowired
	private VfichaAperturaDao vfichaAperturaDao;

	/**
	 * Inserts a single row in the VfichaApertura table.
	 * 
	 *  vfichaApertura
	 *            VfichaApertura
	 *  VfichaApertura
	 *
	 * @param vfichaApertura the vficha apertura
	 * @return the vficha apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VfichaApertura add(VfichaApertura vfichaApertura) {
		return this.vfichaAperturaDao.add(vfichaApertura);
	}

	/**
	 * Updates a single row in the VfichaApertura table.
	 * 
	 *  vfichaApertura
	 *            VfichaApertura
	 *  VfichaApertura
	 *
	 * @param vfichaApertura the vficha apertura
	 * @return the vficha apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VfichaApertura update(VfichaApertura vfichaApertura) {
		return this.vfichaAperturaDao.update(vfichaApertura);
	}

	/**
	 * Finds a single row in the VfichaApertura table.
	 * 
	 *  vfichaApertura
	 *            VfichaApertura
	 *  VfichaApertura
	 *
	 * @param vfichaApertura the vficha apertura
	 * @return the vficha apertura
	 */
	public VfichaApertura find(VfichaApertura vfichaApertura) {
		return (VfichaApertura) this.vfichaAperturaDao.find(vfichaApertura);
	}

	/**
	 * Deletes a single row in the VfichaApertura table.
	 * 
	 *  vfichaApertura
	 *            VfichaApertura
	 *
	 * @param vfichaApertura the vficha apertura
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VfichaApertura vfichaApertura) {
		this.vfichaAperturaDao.remove(vfichaApertura);
	}

	/**
	 * Finds a list of rows in the VfichaApertura table.
	 * 
	 *  vfichaApertura
	 *            VfichaApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VfichaApertura>
	 *
	 * @param vfichaApertura the vficha apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VfichaApertura> findAll(VfichaApertura vfichaApertura,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VfichaApertura>) this.vfichaAperturaDao.findAll(
				vfichaApertura, jqGridRequestDto);
	}

	/**
	 * Finds rows in the VfichaApertura table using like.
	 * 
	 *  vfichaApertura
	 *            VfichaApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VfichaApertura>
	 *
	 * @param vfichaApertura the vficha apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VfichaApertura> findAllLike(VfichaApertura vfichaApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VfichaApertura>) this.vfichaAperturaDao.findAllLike(
				vfichaApertura, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VfichaApertura table.
	 * 
	 *  filterVfichaApertura
	 *            VfichaApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterVfichaApertura the filter vficha apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(VfichaApertura filterVfichaApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.vfichaAperturaDao.removeMultiple(filterVfichaApertura,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the VfichaApertura table.
	 * 
	 *  filterVfichaApertura
	 *            VfichaApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<VfichaApertura>
	 *
	 * @param filterVfichaApertura the filter vficha apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VfichaApertura> filter(
			VfichaApertura filterVfichaApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<VfichaApertura> listaVfichaApertura = this.vfichaAperturaDao
				.findAllLike(filterVfichaApertura, jqGridRequestDto, false);
		Long recordNum = this.vfichaAperturaDao.findAllLikeCount(
				filterVfichaApertura != null ? filterVfichaApertura
						: new VfichaApertura(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VfichaApertura>> reorderSelection = this.vfichaAperturaDao
					.reorderSelection(filterVfichaApertura, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<VfichaApertura>(jqGridRequestDto,
					recordNum, listaVfichaApertura, reorderSelection);
		}
		return new JQGridResponseDto<VfichaApertura>(jqGridRequestDto,
				recordNum, listaVfichaApertura);
	}

	/**
	 * Searches rows in the VfichaApertura table.
	 * 
	 *  filterVfichaApertura
	 *            VfichaApertura
	 *  searchVfichaApertura
	 *            VfichaApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<VfichaApertura>>
	 *
	 * @param filterVfichaApertura the filter vficha apertura
	 * @param searchVfichaApertura the search vficha apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<VfichaApertura>> search(
			VfichaApertura filterVfichaApertura,
			VfichaApertura searchVfichaApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vfichaAperturaDao.search(filterVfichaApertura,
				searchVfichaApertura, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VfichaApertura table.
	 * 
	 *  filterVfichaApertura
	 *            VfichaApertura
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterVfichaApertura the filter vficha apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(VfichaApertura filterVfichaApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vfichaAperturaDao.reorderSelection(filterVfichaApertura,
				jqGridRequestDto, startsWith);
	}

}
